/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import de.ambertation.wunderlib.math.Float3;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.interfaces.ClientLevelAccess;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.client.render.EternalCrystalRenderer;
import org.betterx.betterend.client.render.PedestalItemRenderer;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.rituals.EternalRitual;

public class EternalPedestal
extends PedestalBlock
implements BehaviourStone {
    public static final BooleanProperty ACTIVATED = EndBlockProperties.ACTIVE;

    public EternalPedestal() {
        super(EndBlocks.FLAVOLITE_RUNED_ETERNAL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void checkRitual(Level sourceLevel, Player player, BlockPos pos) {
        BlockEntity blockEntity = sourceLevel.m_7702_(pos);
        if (blockEntity instanceof EternalPedestalEntity) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
            BlockState updatedState = sourceLevel.m_8055_(pos);
            if (pedestal.m_7983_()) {
                EternalRitual ritual;
                if (pedestal.hasRitual() && (ritual = pedestal.getRitual()).isActive()) {
                    ResourceLocation targetWorld;
                    if (ritual.getWorld() == null) {
                        ritual.setWorld(sourceLevel);
                    }
                    int portalId = (targetWorld = ritual.getTargetWorldId()) != null ? EndPortals.getPortalIdByWorld(targetWorld) : EndPortals.getPortalIdByWorld(EndPortals.OVERWORLD_ID);
                    ritual.disablePortal(portalId);
                }
                sourceLevel.m_46597_(pos, (BlockState)((BlockState)updatedState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
            } else {
                ItemStack itemStack = pedestal.m_8020_(0);
                ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
                if (EndPortals.isAvailableItem(id)) {
                    sourceLevel.m_46597_(pos, (BlockState)((BlockState)updatedState.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(true)));
                    if (pedestal.hasRitual()) {
                        if (pedestal.getRitual().getWorld() == null) {
                            pedestal.getRitual().setWorld(sourceLevel);
                        }
                        pedestal.getRitual().checkStructure(player);
                    } else {
                        EternalRitual ritual = new EternalRitual(sourceLevel, pos);
                        pedestal.linkRitual(ritual);
                        ritual.checkStructure(player);
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState updated = super.m_7417_(state, direction, newState, world, pos, posFrom);
        if (!updated.m_60713_((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            return (BlockState)updated.m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return updated;
    }

    @Deprecated
    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return 0.0f;
    }

    public float m_7325_() {
        return Blocks.f_50752_.m_7325_();
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        EternalPedestalEntity pedestal;
        EndBlockProperties.PedestalState currentState;
        if (state.m_60713_((Block)this) && ((currentState = (EndBlockProperties.PedestalState)((Object)state.m_61143_(EndBlockProperties.PEDESTAL_STATE))).equals((Object)EndBlockProperties.PedestalState.BOTTOM) || currentState.equals((Object)EndBlockProperties.PedestalState.PILLAR))) {
            return Lists.newArrayList();
        }
        ArrayList drop = Lists.newArrayList();
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof EternalPedestalEntity && !(pedestal = (EternalPedestalEntity)blockEntity).m_7983_()) {
            drop.add(pedestal.m_8020_(0));
        }
        return drop;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{ACTIVATED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EternalPedestalEntity(blockPos, blockState);
    }

    @Override
    public boolean hasUniqueEntity() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void dispatchParticles(Level level, BlockPos blockPos, RandomSource random) {
        if (level instanceof ClientLevelAccess) {
            EternalPedestalEntity pedestal;
            ClientLevelAccess clientLevel = (ClientLevelAccess)level;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof EternalPedestalEntity && (pedestal = (EternalPedestalEntity)blockEntity).hasRitual()) {
                BlockState state = level.m_8055_(blockPos);
                EternalRitual ritual = pedestal.getRitual();
                if (ritual != null && ritual.getCenter() != null && (ritual.isActive() || ritual.willActivate())) {
                    Particle particle;
                    SimpleParticleType particleOptions;
                    Float3 rnd;
                    int i;
                    boolean powerUp = ritual.willActivate();
                    boolean inX = ritual.getAxis() == Direction.Axis.X;
                    Float3 start = Float3.of((BlockPos)blockPos);
                    Float3 center = Float3.of((BlockPos)ritual.getCenter());
                    Float3 dir = center.sub(start).normalized().mul(powerUp ? 0.2 : 0.05);
                    float[] color = EternalCrystalRenderer.colors(PedestalItemRenderer.getGemAge());
                    if (powerUp) {
                        for (i = 0; i < 30; ++i) {
                            rnd = Float3.of((double)((double)random.m_188501_() * 0.3 - 0.15), (double)((double)random.m_188501_() * -0.1), (double)((double)random.m_188501_() * 0.3 - 0.15)).sub(dir);
                            particleOptions = ParticleTypes.f_175827_;
                            particle = clientLevel.bcl_addParticle((ParticleOptions)particleOptions, center.x + (inX ? 0.0 : (double)(random.m_188501_() * 3.0f) - 1.5), center.y + 1.0 + (double)(random.m_188501_() * 3.0f), center.z + (inX ? (double)(random.m_188501_() * 3.0f) - 1.5 : 0.0), 0.0, 0.0, 0.0);
                            if (particle == null) continue;
                            particle.m_107253_(color[0], color[1], color[2]);
                            particle.m_172260_(rnd.x, rnd.y, rnd.z);
                        }
                    }
                    for (i = 0; i < random.m_216339_(powerUp ? 20 : 2, powerUp ? 40 : 10); ++i) {
                        rnd = Float3.of((double)((double)random.m_188501_() * 0.3 - 0.15), (double)((double)random.m_188501_() * -0.1), (double)((double)random.m_188501_() * 0.3 - 0.15)).add(dir.mul(powerUp ? (double)(random.m_188501_() * 4.0f) : 1.0));
                        particleOptions = ParticleTypes.f_123806_;
                        particle = clientLevel.bcl_addParticle((ParticleOptions)particleOptions, start.x + 0.3 + (double)random.m_188501_() * 0.4, start.y + 1.0 + (double)random.m_188501_() * 0.7, start.z + 0.3 + (double)random.m_188501_() * 0.4, 0.0, 0.0, 0.0);
                        if (particle == null) continue;
                        particle.m_107253_(color[0], color[1], color[2]);
                        particle.m_172260_(rnd.x, rnd.y, rnd.z);
                        if (!powerUp) continue;
                        particle.m_107257_(6 + random.m_188503_(4));
                    }
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        super.m_214162_(blockState, level, blockPos, randomSource);
        this.dispatchParticles(level, blockPos, randomSource);
    }
}

